Attribute VB_Name = "modBNLS"
Private Function GetDWORD(data As String) As Long
Dim lReturn As Long
    Call CopyMemory(lReturn, ByVal data, 4)
    GetDWORD = lReturn
End Function

Private Sub InitCRC32()
    Dim I As Long, J As Long, K As Long, XorVal As Long
    
    Static CRC32Initialized As Boolean
    If CRC32Initialized Then Exit Sub
    CRC32Initialized = True
    
    For I = 0 To 255
        K = I
        
        For J = 1 To 8
            If K And 1 Then XorVal = CRC32_POLYNOMIAL Else XorVal = 0
            If K < 0 Then K = ((K And &H7FFFFFFF) \ 2) Or &H40000000 Else K = K \ 2
            K = K Xor XorVal
        Next
        
        CRC32Table(I) = K
    Next
End Sub

Private Function CRC32(ByVal data As String) As Long
    Dim I As Long, J As Long
    
    Call InitCRC32
    
    CRC32 = &HFFFFFFFF
    
    For I = 1 To Len(data)
        J = CByte(Asc(Mid(data, I, 1))) Xor (CRC32 And &HFF&)
        If CRC32 < 0 Then CRC32 = ((CRC32 And &H7FFFFFFF) \ &H100&) Or &H800000 Else CRC32 = CRC32 \ &H100&
        CRC32 = CRC32 Xor CRC32Table(J)
    Next
    
    CRC32 = Not CRC32
End Function

Public Function BNLSChecksum(ByVal password As String, ByVal ServerCode As Long) As Long
    BNLSChecksum = CRC32(password & Right("0000000" & Hex(ServerCode), 8))
End Function

Public Function GetBNLSByte() As Long
Select Case BNET.Product
    Case "RATS"
        GetBNLSByte = &H1
    Case "PXES"
        GetBNLSByte = &H2
    Case "PX2D"
        GetBNLSByte = &H5
    Case "VD2D"
        GetBNLSByte = &H4
    Case "NB2W"
        GetBNLSByte = &H3
    Case "3RAW"
        GetBNLSByte = &H7
    Case Else
          MsgBox "Invalid Client Type.", vbCritical, "Error"
End Select
End Function

Public Sub ParseBNLS(ByVal data As String)
Select Case Asc(Mid(data, 3, 1))
    Case &H9
        Version = Val("&H" & StrToHex(StrReverse(Mid(data, 8, 4))))
        Version = CLng(Version)
        CheckSum = Val("&H" & StrToHex(StrReverse(Mid(data, 12, 4))))
        CheckSum = CLng(CheckSum)
        ExeInfo = Mid(data, 16, Len(data) - 16)
          If Prod = "PX2D" Then
            With pBuffer
                .InsertDWORD &H0
                .InsertBYTE &H2
                .InsertDWORD &H1
                .InsertDWORD Servers
                .InsertNTString Form2.cdkey.Text
                .InsertNTString Form2.cdkey.Text
                .SendBNLSPacket &HC
            End With
          Else
            With pBuffer
               .InsertDWORD Servers
               .InsertNTString Form2.cdkey.Text
               .SendBNLSPacket &H1
            End With
          End If
    Case &H4
        With pBuffer
            .InsertNonNTString Mid$(data, 4)
            .InsertNTString BNET.username
            .SendPacket &H52
        End With
    Case &H2
       With pBuffer
            .InsertNonNTString Mid(data, 4)
            .InsertNTString BNET.username
            .SendPacket &H53
       End With
    Case &H3
        With pBuffer
            .InsertNonNTString Mid(data, 4)
            .SendPacket &H54
        End With
    Case &HC
        CdkeyHash = Mid(data, 18, 36)
        Cdkey2Hash = Mid(data, 58, 36)
        GTC = Val("&H" & StrToHex(StrReverse(Mid(data, 14, 4))))
        GTC = CLng(GTC)
        Send0x51
    Case &H1
        CdkeyHash = Mid(data, 12)
        GTC = Val("&H" & StrToHex(StrReverse(Mid(data, 8, 4))))
        GTC = CLng(GTC)
        Send0x51
    Case &HE
        Dim key As Long, key2 As Long
        key2 = GetDWORD(Mid(data, 4, 4))
        key = BNLSChecksum("nasty", key2)
        With pBuffer
            .InsertDWORD key
            .SendBNLSPacket &HF
        End With
    Case &HB
        If HType = 1 Then
          CB = CB + 1
            If CB = 1 Then
                Hash(0) = pBuffer.MakeDWORD(GTC)
                Hash(1) = pBuffer.MakeDWORD(Servers)
                Hash(2) = Mid(data, 4, Len(data) - 3)
                With pBuffer
                    .InsertDWORD &H1C
                    .InsertDWORD &H1
                    .InsertNonNTString Hash(0) & Hash(1) & Hash(2)
                    .SendBNLSPacket &HB
                End With
            ElseIf CB = 2 Then
                With pBuffer
                    If SPass = True Then
                        .InsertDWORD GTC
                        .InsertDWORD Servers
                        .InsertNonNTString Mid(data, 4, Len(data) - 3)
                        .InsertNTString BNET.username
                        .SendPacket &H3A
                        SPass = False
                        CB = 0
                    Else
                        .InsertDWORD GTC
                        .InsertNonNTString Mid(data, 4, Len(data) - 3)
                        .InsertNTString BNET.Realm
                        .SendPacket &H3E
                        CB = 0
                    End If
                End With
            End If
        ElseIf HType = 2 Then
            With pBuffer
                .InsertNonNTString Mid(data, 4, Len(data) - 3)
                .InsertNTString BNET.username
                .SendPacket &H2A
            End With
        ElseIf HType = 3 Then
            Static Hash2 As String
            CB = CB + 1
            If CB = 1 Then
                Hash(0) = pBuffer.MakeDWORD(GTC)
                Hash(1) = pBuffer.MakeDWORD(Servers)
                Hash(2) = Mid(data, 4, Len(data) - 3)
                With pBuffer
                    .InsertDWORD &H1C
                    .InsertDWORD &H1
                    .InsertNonNTString Hash(0) & Hash(1) & Hash(2)
                    .SendBNLSPacket &HB
                End With
            End If
            If CB = 2 Then
                Hash2 = Mid(data, 4, Len(data) - 3)
                With pBuffer
                    .InsertDWORD "&h" & Len(BNET.NewPass)
                    .InsertDWORD &H0
                    .InsertNonNTString BNET.NewPass
                    .SendBNLSPacket &HB
                End With
            End If
            If CB = 3 Then
                With pBuffer
                    .InsertDWORD GTC
                    .InsertDWORD Servers
                    .InsertNonNTString Hash2
                    .InsertNonNTString Mid(data, 4, Len(data) - 3)
                    .InsertNTString BNET.username
                    .SendPacket &H31
                End With
            End If
        End If
    Case &HF
        pBuffer.InsertDWORD GetBNLSByte()
        pBuffer.SendBNLSPacket &H10
        If BNET.Product = "3RAW" Then
            With pBuffer
                .InsertDWORD &H2
                .SendBNLSPacket &HD
            End With
        End If
    Case &H10
        VerByte = GetDWORD(Mid(data, 8, 4))
        frmMain.wsBnet.Close
        frmMain.wsBnet.Connect BNET.BattlenetServer, 6112
End Select
End Sub
